
<?php
require_once __DIR__.'/includes/auth.php';
$err = '';
if (is_post()) {
    [$ok, $msg] = login_with_wp($_POST['login'] ?? '', $_POST['password'] ?? '');
    if ($ok) {
        $role = $_SESSION['role'] ?? 'customer';
        if ($role === 'super_admin') redirect('/super-admin.php');
        if ($role === 'office_admin') redirect('/office-admin.php');
        redirect('/customer-dashboard.php');
    } else {
        $err = $msg;
    }
}
?>
<!doctype html>
<html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login</title>
<link rel="stylesheet" href="/assets/css/style.css"/>
</head><body>
<main class="container narrow">
  <h1>Login</h1>
  <?php if ($err): ?><div class="alert error"><?php echo esc($err); ?></div><?php endif; ?>
  <form method="post">
    <label>Email or Username
      <input name="login" required>
    </label>
    <label>Password
      <input name="password" type="password" required>
    </label>
    <button class="btn">Sign in</button>
  </form>
</main>
</body></html>
