
<?php
require_once __DIR__.'/includes/auth.php';
require_roles(['office_admin','super_admin']);
require_once __DIR__.'/../config/db.php';

// Today's bookings
$stmt = $pdo->prepare("SELECT b.*, u.display_name FROM bookings b LEFT JOIN {$WP_PREFIX}users u ON u.ID=b.customer_user_id WHERE booking_date = CURDATE() ORDER BY slot_time");
$stmt->execute();
$rows = $stmt->fetchAll();
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Office Admin</title>
<link rel="stylesheet" href="/assets/css/style.css"/>
</head><body>
<main class="container">
  <h1>Office Admin</h1>
  <table class="table">
    <thead><tr><th>Time</th><th>Customer</th><th>Pax</th><th>Status</th><th>Total</th><th>Actions</th></tr></thead>
    <tbody>
      <?php foreach ($rows as $r): ?>
      <tr>
        <td><?php echo esc(substr($r['slot_time'],0,5)); ?></td>
        <td><?php echo esc($r['display_name']); ?></td>
        <td><?php echo esc($r['pax_adults'] + $r['pax_kids']); ?></td>
        <td><?php echo esc($r['status']); ?></td>
        <td><?php echo money($r['total_amount']); ?></td>
        <td>
          <?php if ($r['status'] !== 'checked_in'): ?>
          <form method="post" action="/bookings.php" style="display:inline">
            <input type="hidden" name="action" value="check_in">
            <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
            <button class="btn">Check-in</button>
          </form>
          <?php endif; ?>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
  <p><a href="/logout.php">Logout</a></p>
</main>
</body></html>
