
<?php
require_once __DIR__.'/../includes/auth.php';
require_login();
require_once __DIR__.'/../../config/db.php';

$id = (int)($_GET['booking_id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM bookings WHERE id=?");
$stmt->execute([$id]);
$b = $stmt->fetch();
if (!$b) { http_response_code(404); exit('Booking not found'); }

// Create checkout with Yoco Checkouts API
$payload = [
  'amount' => (int)round($b['balance_amount'] * 100),
  'currency' => 'ZAR',
  'success_url' => (isset($_SERVER['HTTPS'])?'https':'http') . '://' . $_SERVER['HTTP_HOST'] . '/pay/return.php?booking_id='.$b['id'],
  'cancel_url'  => (isset($_SERVER['HTTPS'])?'https':'http') . '://' . $_SERVER['HTTP_HOST'] . '/customer-dashboard.php',
  'metadata' => ['booking_id' => (string)$b['id'], 'code' => $b['booking_code']]
];

$ch = curl_init('https://payments.yoco.com/api/checkouts');
curl_setopt_array($ch, [
  CURLOPT_POST           => true,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_HTTPHEADER     => [
    'Content-Type: application/json',
    'X-Auth-Secret-Key: ' . $YOCO_SECRET_KEY,
  ],
  CURLOPT_POSTFIELDS     => json_encode($payload),
  CURLOPT_TIMEOUT        => 20,
]);
$resp = curl_exec($ch);
curl_close($ch);
$checkout = json_decode($resp, true) ?: [];
if (empty($checkout['redirect_url'])) {
  http_response_code(502);
  echo "<pre>Yoco error:\n".htmlspecialchars($resp)."</pre>";
  exit;
}

// Save checkout id & pending payment
$pdo->prepare("INSERT INTO payments (booking_id, gateway, amount, currency, external_id, status, raw_json, created_at) VALUES (?,?,?,?,?,'pending',?,NOW())")
    ->execute([$b['id'], 'yoco', $b['balance_amount'], 'ZAR', $checkout.get('id',''), $resp]);
$pdo->prepare("UPDATE bookings SET yoco_checkout_id=? WHERE id=?")->execute([$checkout.get('id',''), $b['id']]);

header('Location: '.$checkout['redirect_url']);
exit;
